UNIT Unit1;

INTERFACE

USES
  Windows, Messages, SysUtils, Classes, Forms, Dialogs, Registry, Controls, StdCtrls;

TYPE
  THaupt_Form = CLASS(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    ComboBox3: TComboBox;
    ComboBox4: TComboBox;
    ComboBox5: TComboBox;
    ComboBox6: TComboBox;
    ComboBox7: TComboBox;
    ComboBox8: TComboBox;
    ComboBox9: TComboBox;
    ComboBox10: TComboBox;
    ComboBox11: TComboBox;
    ComboBox12: TComboBox;
    ComboBox13: TComboBox;
    ComboBox14: TComboBox;
    ComboBox15: TComboBox;
    ComboBox16: TComboBox;
    ComboBox17: TComboBox;
    ComboBox18: TComboBox;
    ComboBox19: TComboBox;
    ComboBox20: TComboBox;
    ComboBox21: TComboBox;
    ComboBox22: TComboBox;
    BT_Reset: TButton;
    BT_Apply: TButton;
    BT_End: TButton;
    BT_Current: TButton;
    BT_Config: TButton;
    CB_Topics: TComboBox;
    BT_View: TButton;
    PROCEDURE BT_ResetClick(Sender: TObject);
    PROCEDURE FormCreate(Sender: TObject);
    PROCEDURE BT_CurrentClick(Sender: TObject);
    PROCEDURE BT_ApplyClick(Sender: TObject);
    procedure BT_EndClick(Sender: TObject);
    procedure BT_ConfigClick(Sender: TObject);
    procedure BT_ViewClick(Sender: TObject);
    procedure CB_TopicsChange(Sender: TObject);
  PRIVATE
    PROCEDURE GetMinFreqs;
    FUNCTION GetResFreq (Res: STRING):BYTE;
    FUNCTION ResetValues: BOOLEAN;
    PROCEDURE SetNewValues;
    PROCEDURE DelValuesBelow (Res: STRING; Freq: BYTE);
    FUNCTION Restart: BOOLEAN;
    PROCEDURE RedrawInscriptions;
  PUBLIC
    PROCEDURE ShowStartMessage;
    PROCEDURE SetLanguage (Lng: BYTE);
  END;


VAR
  Haupt_Form: THaupt_Form;
  Base_Key: HKEY;
  Base_Path, Base_Back, Config_Path, Hive_File: STRING;
  Orig_320x200, Orig_320x240, Orig_400x300, Orig_512x384, Orig_640x400, Orig_640x480,
  Orig_720x480, Orig_720x576, Orig_800x600, Orig_960x720, Orig_1024x768, Orig_1152x864,
  Orig_1280x960, Orig_1280x1024, Orig_1600x1024, Orig_1600x1200, Orig_1792x1344,
  Orig_1856x1392, Orig_1920x1080, Orig_1920x1200, Orig_1920x1440, Orig_2048x1536: BYTE;
  Reg: TRegistry;
  Language: Byte;
  Warn_Start: BOOLEAN;

IMPLEMENTATION

USES Unit2, Unit4, Unit5;

{$R *.DFM}


PROCEDURE THaupt_Form.BT_ResetClick(Sender: TObject);
BEGIN
ComboBox1.ItemIndex:=0;
ComboBox2.ItemIndex:=0;
ComboBox3.ItemIndex:=0;
ComboBox4.ItemIndex:=0;
ComboBox5.ItemIndex:=0;
ComboBox6.ItemIndex:=0;
ComboBox7.ItemIndex:=0;
ComboBox8.ItemIndex:=0;
ComboBox9.ItemIndex:=0;
ComboBox10.ItemIndex:=0;
ComboBox11.ItemIndex:=0;
ComboBox12.ItemIndex:=0;
ComboBox13.ItemIndex:=0;
ComboBox14.ItemIndex:=0;
ComboBox15.ItemIndex:=0;
ComboBox16.ItemIndex:=0;
ComboBox17.ItemIndex:=0;
ComboBox18.ItemIndex:=0;
ComboBox19.ItemIndex:=0;
ComboBox20.ItemIndex:=0;
ComboBox21.ItemIndex:=0;
ComboBox22.ItemIndex:=0;
END;


PROCEDURE THaupt_Form.FormCreate(Sender: TObject);
BEGIN
Base_Key:=HKEY_LOCAL_MACHINE;
Base_Path:='\System\CurrentControlSet\Services\3dfxvs\Device0\TIMINGS';
Base_Back:='\System\CurrentControlSet\Services\3dfxvs\Device0\TIMINGS-OLD-VFS';
Config_Path:='\SOFTWARE\TDFC\V5FS';
GetMinFreqs;
BT_CurrentClick (NIL);
Language:=0;
Hive_File:='';
Reg:=TRegistry.Create;
Reg.RootKey:=Base_Key;
IF (Reg.KeyExists(Config_Path))
 THEN
  BEGIN
  Reg.OpenKey (Config_Path , FALSE);
  TRY Language:=Reg.ReadInteger ('Language');
   EXCEPT Language:=0;
   END;
  TRY Hive_File:=Reg.ReadString ('OriginalValuesFile');
   EXCEPT Hive_File:='';
   END;
  TRY Warn_Start:=Reg.ReadBool ('WarningStartup');
   EXCEPT Warn_Start:=TRUE;
   END;
  Reg.CloseKey;
  END;
IF NOT (Reg.KeyExists(Base_Path))
 THEN ShowMessage ('ATTENTION: Unable to find registry path' + CHR(13) +
                   'HKEY_LOCAL_MACHINE' + Base_Path + CHR(13) +
                   'This could indicate a non 3DFX card or an unknown driver' + CHR(13) +
                   'It is advised not to make any changes!' + CHR(13) + CHR(13) +
                   'ACHTUNG: Kann Registry-Pfad nicht finden' + CHR(13) +
                   'HKEY_LOCAL_MACHINE' + Base_Path + CHR(13) +
                   'Die ist ein Indiz fr eine nicht 3DFX-Karte oder einen unbekannten Treiber' + CHR(13) +
                   'Es wird empfohlen, keinerlei nderungen vorzunehmen!');
Reg.Free;
IF ((Hive_File<>'') AND (FileExists(Hive_File)=FALSE))
 THEN Hive_File:='';
IF NOT ((Language = 0) OR (Language = 1) OR (Language = 2))
 THEN Language:=0;
IF (Language <> 0)
 THEN RedrawInscriptions;
END;


PROCEDURE THaupt_Form.BT_CurrentClick(Sender: TObject);
BEGIN
CASE Orig_320x200 OF
 70: ComboBox1.ItemIndex:=0;
 85: ComboBox1.ItemIndex:=1;
 ELSE ComboBox1.ItemIndex:=0;
 END;
CASE Orig_320x240 OF
 60: ComboBox2.ItemIndex:=0;
 72: ComboBox2.ItemIndex:=1;
 75: ComboBox2.ItemIndex:=2;
 85: ComboBox2.ItemIndex:=3;
 ELSE ComboBox2.ItemIndex:=0;
 END;
CASE Orig_400x300 OF
 60: ComboBox3.ItemIndex:=0;
 72: ComboBox3.ItemIndex:=1;
 75: ComboBox3.ItemIndex:=2;
 85: ComboBox3.ItemIndex:=3;
 ELSE ComboBox3.ItemIndex:=0;
 END;
CASE Orig_512x384 OF
 60: ComboBox4.ItemIndex:=0;
 70: ComboBox4.ItemIndex:=1;
 75: ComboBox4.ItemIndex:=2;
 85: ComboBox4.ItemIndex:=3;
 ELSE ComboBox4.ItemIndex:=0;
 END;
CASE Orig_640x400 OF
 70: ComboBox5.ItemIndex:=0;
 85: ComboBox5.ItemIndex:=1;
 ELSE ComboBox5.ItemIndex:=0;
 END;
CASE Orig_640x480 OF
 60: ComboBox6.ItemIndex:=0;
 72: ComboBox6.ItemIndex:=1;
 75: ComboBox6.ItemIndex:=2;
 85: ComboBox6.ItemIndex:=3;
 100: ComboBox6.ItemIndex:=4;
 120: ComboBox6.ItemIndex:=5;
 140: ComboBox6.ItemIndex:=6;
 160: ComboBox6.ItemIndex:=7;
 ELSE ComboBox6.ItemIndex:=0;
 END;
CASE Orig_720x480 OF
 60: ComboBox7.ItemIndex:=0;
 72: ComboBox7.ItemIndex:=1;
 85: ComboBox7.ItemIndex:=2;
 ELSE ComboBox7.ItemIndex:=0;
 END;
CASE Orig_720x576 OF
 72: ComboBox8.ItemIndex:=0;
 100: ComboBox8.ItemIndex:=1;
 ELSE ComboBox8.ItemIndex:=0;
 END;
CASE Orig_800x600 OF
 56: ComboBox9.ItemIndex:=0;
 60: ComboBox9.ItemIndex:=1;
 72: ComboBox9.ItemIndex:=2;
 75: ComboBox9.ItemIndex:=3;
 85: ComboBox9.ItemIndex:=4;
 100: ComboBox9.ItemIndex:=5;
 120: ComboBox9.ItemIndex:=6;
 140: ComboBox9.ItemIndex:=7;
 160: ComboBox9.ItemIndex:=8;
 ELSE ComboBox9.ItemIndex:=0;
 END;
CASE Orig_960x720 OF
 60: ComboBox10.ItemIndex:=0;
 75: ComboBox10.ItemIndex:=1;
 85: ComboBox10.ItemIndex:=2;
 ELSE ComboBox10.ItemIndex:=0;
 END;
CASE Orig_1024x768 OF
 60: ComboBox11.ItemIndex:=0;
 70: ComboBox11.ItemIndex:=1;
 75: ComboBox11.ItemIndex:=2;
 85: ComboBox11.ItemIndex:=3;
 100: ComboBox11.ItemIndex:=4;
 120: ComboBox11.ItemIndex:=5;
 ELSE ComboBox11.ItemIndex:=0;
 END;
CASE Orig_1152x864 OF
 60: ComboBox12.ItemIndex:=0;
 70: ComboBox12.ItemIndex:=1;
 75: ComboBox12.ItemIndex:=2;
 85: ComboBox12.ItemIndex:=3;
 100: ComboBox12.ItemIndex:=4;
 120: ComboBox12.ItemIndex:=5;
 ELSE ComboBox12.ItemIndex:=0;
 END;
CASE Orig_1280x960 OF
 60: ComboBox13.ItemIndex:=0;
 75: ComboBox13.ItemIndex:=1;
 85: ComboBox13.ItemIndex:=2;
 ELSE ComboBox13.ItemIndex:=0;
 END;
CASE Orig_1280x1024 OF
 60: ComboBox14.ItemIndex:=0;
 75: ComboBox14.ItemIndex:=1;
 85: ComboBox14.ItemIndex:=2;
 100: ComboBox14.ItemIndex:=3;
 ELSE ComboBox14.ItemIndex:=0;
 END;
CASE Orig_1600x1024 OF
 60: ComboBox15.ItemIndex:=0;
 76: ComboBox15.ItemIndex:=1;
 85: ComboBox15.ItemIndex:=2;
 ELSE ComboBox15.ItemIndex:=0;
 END;
CASE Orig_1600x1200 OF
 60: ComboBox16.ItemIndex:=0;
 65: ComboBox16.ItemIndex:=1;
 70: ComboBox16.ItemIndex:=2;
 75: ComboBox16.ItemIndex:=3;
 80: ComboBox16.ItemIndex:=4;
 85: ComboBox16.ItemIndex:=5;
 100: ComboBox16.ItemIndex:=6;
 ELSE ComboBox16.ItemIndex:=0;
 END;
CASE Orig_1792x1344 OF
 60: ComboBox17.ItemIndex:=0;
 75: ComboBox17.ItemIndex:=1;
 ELSE ComboBox17.ItemIndex:=0;
 END;
CASE Orig_1856x1392 OF
 60: ComboBox18.ItemIndex:=0;
 75: ComboBox18.ItemIndex:=1;
 ELSE ComboBox18.ItemIndex:=0;
 END;
CASE Orig_1920x1080 OF
 60: ComboBox19.ItemIndex:=0;
 72: ComboBox19.ItemIndex:=1;
 75: ComboBox19.ItemIndex:=2;
 85: ComboBox19.ItemIndex:=3;
 ELSE ComboBox19.ItemIndex:=0;
 END;
CASE Orig_1920x1200 OF
 60: ComboBox20.ItemIndex:=0;
 76: ComboBox20.ItemIndex:=1;
 85: ComboBox20.ItemIndex:=2;
 ELSE ComboBox20.ItemIndex:=0;
 END;
CASE Orig_1920x1440 OF
 60: ComboBox21.ItemIndex:=0;
 75: ComboBox21.ItemIndex:=1;
 ELSE ComboBox21.ItemIndex:=0;
 END;
CASE Orig_2048x1536 OF
 60: ComboBox22.ItemIndex:=0;
 75: ComboBox22.ItemIndex:=1;
 ELSE ComboBox22.ItemIndex:=0;
 END;
END;


PROCEDURE THaupt_Form.GetMinFreqs;
BEGIN
Orig_320x200:=GetResFreq ('320,200');
Orig_320x240:=GetResFreq ('320,240');
Orig_400x300:=GetResFreq ('400,300');
Orig_512x384:=GetResFreq ('512,384');
Orig_640x400:=GetResFreq ('640,400');
Orig_640x480:=GetResFreq ('640,480');
Orig_720x480:=GetResFreq ('720,480');
Orig_720x576:=GetResFreq ('720,576');
Orig_800x600:=GetResFreq ('800,600');
Orig_960x720:=GetResFreq ('960,720');
Orig_1024x768:=GetResFreq ('1024,768');
Orig_1152x864:=GetResFreq ('1152,864');
Orig_1280x960:=GetResFreq ('1280,960');
Orig_1280x1024:=GetResFreq ('1280,1024');
Orig_1600x1024:=GetResFreq ('1600,1024');
Orig_1600x1200:=GetResFreq ('1600,1200');
Orig_1792x1344:=GetResFreq ('1792,1344');
Orig_1856x1392:=GetResFreq ('1856,1392');
Orig_1920x1080:=GetResFreq ('1920,1080');
Orig_1920x1200:=GetResFreq ('1920,1200');
Orig_1920x1440:=GetResFreq ('1920,1440');
Orig_2048x1536:=GetResFreq ('2048,1536');
END;


FUNCTION THaupt_Form.GetResFreq (Res: STRING): BYTE;
BEGIN
Result:=0;
Reg:=TRegistry.Create;
Reg.RootKey:=Base_Key;
IF (Reg.KeyExists(Base_Path+'\'+Res+'\160Hz')) THEN Result:=160;
IF (Reg.KeyExists(Base_Path+'\'+Res+'\140Hz')) THEN Result:=140;
IF (Reg.KeyExists(Base_Path+'\'+Res+'\120Hz')) THEN Result:=120;
IF (Reg.KeyExists(Base_Path+'\'+Res+'\100Hz')) THEN Result:=100;
IF (Reg.KeyExists(Base_Path+'\'+Res+'\85Hz')) THEN Result:=85;
IF (Reg.KeyExists(Base_Path+'\'+Res+'\80Hz')) THEN Result:=80;
IF (Reg.KeyExists(Base_Path+'\'+Res+'\76Hz')) THEN Result:=76;
IF (Reg.KeyExists(Base_Path+'\'+Res+'\75Hz')) THEN Result:=75;
IF (Reg.KeyExists(Base_Path+'\'+Res+'\72Hz')) THEN Result:=72;
IF (Reg.KeyExists(Base_Path+'\'+Res+'\70Hz')) THEN Result:=70;
IF (Reg.KeyExists(Base_Path+'\'+Res+'\65Hz')) THEN Result:=65;
IF (Reg.KeyExists(Base_Path+'\'+Res+'\60Hz')) THEN Result:=60;
IF (Reg.KeyExists(Base_Path+'\'+Res+'\56Hz')) THEN Result:=56;
Reg.Free;
END;


PROCEDURE THaupt_Form.BT_ApplyClick(Sender: TObject);
VAR tempreq, temperr: STRING;
    tempres: BOOLEAN;
BEGIN
IF (FileExists(Hive_File) = FALSE)
 THEN
  BEGIN
  IF (Language = 1)
   THEN ShowMessage ('File containig the original values has been deleted or renamed' + CHR(13) +
                     'create a new file or select one.')
   ELSE ShowMessage ('Datei mit Original-Werten wurde gelscht oder umbenannt.' + CHR(13) +
                     'Erstellen Sie eine neue Datei oder whlen Sie eine aus.');
  Hive_File:='';
  Config_Form.ShowModal;
  END;
tempres:=ResetValues;
IF (tempres)
 THEN
  BEGIN
  SetNewValues;
  GetMinFreqs;
  IF (Language = 1)
   THEN
    BEGIN
    tempreq:='The computer must be restarted for the changes to take effect,' + CHR(13) +
             'because the drivers loads these setting on Windows startup.' + CHR(13) + CHR(13) +
             'Restart the computer now?';
    temperr:='Computer could not be restarted!' + CHR(13) + 'Your user possibly does not have the required rights.';
    END
   ELSE
    BEGIN
    tempreq:='Zum bernehmen der Einstellungen mu der Computer neu gestartet werden,' + CHR(13) +
             'da der Treiber diese Einstellungen schon beim Windows-Start ldt.' + CHR(13) + CHR(13) +
             'Computer jetzt neu starten?';
    temperr:='Computer konnte nicht neu gestartet werden!' + CHR(13) + 'Evtl. besitzt Ihr Benutzer nicht die ntigen Rechte!';
    END;
  IF (MessageDlg(tempreq , mtConfirmation , [mbYes,mbNo] , 0) = mrYes)
   THEN
    BEGIN
    IF (Restart)
     THEN HALT(0)
     ELSE ShowMessage (temperr);
    END;
  END
 ELSE
  IF (Language = 1)
   THEN ShowMessage ('Unable to apply the changes:' + CHR(13) +
                     'The file containing the original settings is corrupted,' + CHR(13) +
                     'another program already accesses this part of the registry' + CHR(13) +
                     'or your user possibly does not have the required rights.')
   ELSE ShowMessage ('Kann die Einstellungen nicht bernehmen:'+ CHR(13) +
                     'Datei mit den Original-Einstellungen ist defekt,' + CHR(13) +
                     'ein anderes Programm greift bereits auf diesen Teil der Registry zu' + CHR(13) +
                     'oder Ihr Benutzer besitzt nicht die erforderlichen Rechte!');
END;


FUNCTION THaupt_Form.ResetValues: BOOLEAN;
VAR Privs, PrivsOld: _TOKEN_PRIVILEGES;
    pls: INT64;
    lngProcess, lngTokenPrivileges, lngToken, RL: Cardinal;
BEGIN
lngProcess:=GetCurrentProcess;
lngTokenPrivileges:=TOKEN_ADJUST_PRIVILEGES OR TOKEN_QUERY;
OpenProcessToken (lngProcess , lngTokenPrivileges , lngToken);
LookupPrivilegeValue (PChar('') , PChar('SeBackupPrivilege') , pls);
Privs.PrivilegeCount:=1;
Privs.Privileges[0].Attributes:=SE_PRIVILEGE_ENABLED;
Privs.Privileges[0].Luid:=pls;
AdjustTokenPrivileges (lngToken , FALSE , Privs , SizeOf(PrivsOld) , PrivsOld, RL);
lngProcess:=GetCurrentProcess;
lngTokenPrivileges:=TOKEN_ADJUST_PRIVILEGES OR TOKEN_QUERY;
OpenProcessToken (lngProcess , lngTokenPrivileges , lngToken);
LookupPrivilegeValue (PChar('') , PChar('SeRestorePrivilege') , pls);
Privs.PrivilegeCount:=1;
Privs.Privileges[0].Attributes:=SE_PRIVILEGE_ENABLED;
Privs.Privileges[0].Luid:=pls;
AdjustTokenPrivileges (lngToken , FALSE , Privs , SizeOf(PrivsOld) , PrivsOld, RL);
Reg:=TRegistry.Create;
Reg.CloseKey;
Reg.RootKey:=Base_Key;
Reg.CloseKey;
IF (Reg.KeyExists(Base_Path))
 THEN Reg.MoveKey (Base_Path, Base_Back, TRUE);
Reg.OpenKey (Base_Path , TRUE);
Reg.CloseKey;
Result:=Reg.RestoreKey (Base_Path, Hive_File);
IF (Reg.KeyExists(Base_Back))
 THEN
  IF (Result)
   THEN Reg.DeleteKey (Base_Back)
   ELSE
    BEGIN
    IF (Reg.KeyExists(Base_Path)) THEN Reg.DeleteKey(Base_Path);
    Reg.MoveKey (Base_Back, Base_Path, TRUE);
    END;
Reg.Free;
END;


PROCEDURE THaupt_Form.SetNewValues;
VAR temp:STRING;
BEGIN
temp:=ComboBox1.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('320,200',StrToInt(temp));
temp:=ComboBox2.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('320,240',StrToInt(temp));
temp:=ComboBox3.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('400,300',StrToInt(temp));
temp:=ComboBox4.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('512,384',StrToInt(temp));
temp:=ComboBox5.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('640,400',StrToInt(temp));
temp:=ComboBox6.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('640,480',StrToInt(temp));
temp:=ComboBox7.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('720,480',StrToInt(temp));
temp:=ComboBox8.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('720,576',StrToInt(temp));
temp:=ComboBox9.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('800,600',StrToInt(temp));
temp:=ComboBox10.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('960,720',StrToInt(temp));
temp:=ComboBox11.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('1024,768',StrToInt(temp));
temp:=ComboBox12.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('1152,864',StrToInt(temp));
temp:=ComboBox13.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('1280,960',StrToInt(temp));
temp:=ComboBox14.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('1280,1024',StrToInt(temp));
temp:=ComboBox15.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('1600,1024',StrToInt(temp));
temp:=ComboBox16.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('1600,1200',StrToInt(temp));
temp:=ComboBox17.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('1792,1344',StrToInt(temp));
temp:=ComboBox18.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('1856,1392',StrToInt(temp));
temp:=ComboBox19.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('1920,1080',StrToInt(temp));
temp:=ComboBox20.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('1920,1200',StrToInt(temp));
temp:=ComboBox21.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('1920,1440',StrToInt(temp));
temp:=ComboBox22.Text;
Delete (temp,Length(temp)-1,2);
DelValuesBelow ('2048,1536',StrToInt(temp));
END;


PROCEDURE THaupt_Form.DelValuesBelow (Res: STRING; Freq: BYTE);
BEGIN
Reg:=TRegistry.Create;
Reg.RootKey:=Base_Key;
IF (Freq > 56) THEN Reg.DeleteKey (Base_Path + '\' + Res + '\56Hz');
IF (Freq > 60) THEN Reg.DeleteKey (Base_Path + '\' + Res + '\60Hz');
IF (Freq > 65) THEN Reg.DeleteKey (Base_Path + '\' + Res + '\65Hz');
IF (Freq > 70) THEN Reg.DeleteKey (Base_Path + '\' + Res + '\70Hz');
IF (Freq > 72) THEN Reg.DeleteKey (Base_Path + '\' + Res + '\72Hz');
IF (Freq > 75) THEN Reg.DeleteKey (Base_Path + '\' + Res + '\75Hz');
IF (Freq > 76) THEN Reg.DeleteKey (Base_Path + '\' + Res + '\76Hz');
IF (Freq > 80) THEN Reg.DeleteKey (Base_Path + '\' + Res + '\80Hz');
IF (Freq > 85) THEN Reg.DeleteKey (Base_Path + '\' + Res + '\85Hz');
IF (Freq > 100) THEN Reg.DeleteKey (Base_Path + '\' + Res + '\100Hz');
IF (Freq > 120) THEN Reg.DeleteKey (Base_Path + '\' + Res + '\120Hz');
IF (Freq > 140) THEN Reg.DeleteKey (Base_Path + '\' + Res + '\140Hz');
IF (Freq > 160) THEN Reg.DeleteKey (Base_Path + '\' + Res + '\160Hz');
Reg.Free;
END;


FUNCTION THaupt_Form.Restart: BOOLEAN;
var Privs, PrivsOld: _TOKEN_PRIVILEGES;
    pls: INT64;
    lngProcess, lngTokenPrivileges, lngToken, RL: Cardinal;
BEGIN
lngProcess:=GetCurrentProcess;
lngTokenPrivileges:=TOKEN_ADJUST_PRIVILEGES OR TOKEN_QUERY;
OpenProcessToken (lngProcess , lngTokenPrivileges , lngToken);
LookupPrivilegeValue (PChar('') , PChar('SeShutdownPrivilege') , pls);
Privs.PrivilegeCount:=1;
Privs.Privileges[0].Attributes:=SE_PRIVILEGE_ENABLED;
Privs.Privileges[0].Luid:=pls;
AdjustTokenPrivileges (lngToken , FALSE , Privs , SizeOf(PrivsOld) , PrivsOld, RL);
Result:=ExitWindowsEx (EWX_REBOOT OR EWX_LOGOFF,0);
END;


procedure THaupt_Form.BT_EndClick(Sender: TObject);
begin
Close;
end;


PROCEDURE THaupt_Form.ShowStartMessage;
BEGIN
IF (Warn_Start)
 THEN
  IF (Language=1)
   THEN ShowMessage ('ATTENTION:' + CHR(13) +
                     'I don''t take any responsibility for damages to hard-/software' + CHR(13) +
                     'caused by the usage of this program.' + CHR(13) + CHR(13) +
                     'Don''t set the frequency values to high!' + CHR(13) +
                     'Get to know which frequencies your screen can handle!')
   ELSE ShowMessage ('ACHTUNG:' + CHR(13) +
                     'Ich bernehme keinerlei Haftung fr Schden an Hard-/Software,' + CHR(13) +
                     'die durch Benutzung dieses Programmes hervorgerufen werden.' + CHR(13) + CHR(13) +
                     'Setzen Sie die Werte fr die Bildfrequenzen nicht zu hoch!' + CHR(13) +
                     'Informieren Sie sich, welche Freqenzen Ihr Monitor darstellen kann!');
END;


PROCEDURE THaupt_Form.SetLanguage (Lng: BYTE);
BEGIN
Reg:=TRegistry.Create;
Reg.RootKey:=Base_Key;
Reg.OpenKey (Config_Path , TRUE);
Reg.WriteInteger ('Language' , Lng);
Reg.Free;
Language:=Lng;
RedrawInscriptions;
END;


PROCEDURE THaupt_Form.RedrawInscriptions;
BEGIN
IF (Language = 1)
 THEN
  BEGIN
  BT_Reset.Caption:='&Standard values';
  BT_Current.Caption:='&Current values';
  BT_Apply.Caption:='&Apply';
  BT_End.Caption:='&Exit';
  BT_Config.Caption:='C&onfiguration';
  BT_View.Caption:='&View';
  CB_Topics.Items.Clear;
  CB_Topics.Items.Add ('--Select a topic--');
  CB_Topics.Items.Add ('Usage / Instructions');
  CB_Topics.Items.Add ('Function / history');
  CB_Topics.Items.Add ('FAQ / Help');
  CB_Topics.Items.Add ('Legal notes');
  CB_Topics.Items.Add ('Program info');
  END
 ELSE
  BEGIN
  BT_Reset.Caption:='&Standard-Werte';
  BT_Current.Caption:='&Aktuelle Werte';
  BT_Apply.Caption:='&bernehmen';
  BT_End.Caption:='&Beenden';
  BT_Config.Caption:='&Konfiguration';
  BT_View.Caption:='An&zeigen';
  CB_Topics.Items.Clear;
  CB_Topics.Items.Add ('--Whlen Sie ein Thema--');
  CB_Topics.Items.Add ('Benutzung / Anleitung');
  CB_Topics.Items.Add ('Funktion / Historie');
  CB_Topics.Items.Add ('FAQ / Hilfe');
  CB_Topics.Items.Add ('Rechtliche Hinweise');
  CB_Topics.Items.Add ('Programm-Info');
  END;
CB_Topics.ItemIndex:=0;
CB_TopicsChange (NIL);
END;


procedure THaupt_Form.BT_ConfigClick(Sender: TObject);
BEGIN
Haupt_Form.Enabled:=FALSE;
Config_Form.ShowModal;
end;


procedure THaupt_Form.BT_ViewClick(Sender: TObject);
VAR tempdir: STRING;
begin
tempdir:=GetCurrentDir + '\';
IF (CB_Topics.ItemIndex = 1)
 THEN
  BEGIN
  IF (Language = 1)
   THEN
    BEGIN
    Unit5.FileToView:=tempdir+'EN_Usage.txt';
    Unit5.CaptionToShow:='Program manual';
    END
   ELSE
    BEGIN
    Unit5.FileToView:=tempdir+'DE_Usage.txt';
    Unit5.CaptionToShow:='Anleitung des Programms';
    END;
  Viewer_Form.ShowModal;
  END;
IF (CB_Topics.ItemIndex = 2)
 THEN
  BEGIN
  IF (Language = 1)
   THEN
    BEGIN
    Unit5.FileToView:=tempdir+'EN_Function.txt';
    Unit5.CaptionToShow:='Program function and version history';
    END
   ELSE
    BEGIN
    Unit5.FileToView:=tempdir+'DE_Function.txt';
    Unit5.CaptionToShow:='Funktionsweise des Programms und Versionsgeschichte';
    END;
  Viewer_Form.ShowModal;
  END;
IF (CB_Topics.ItemIndex = 3)
 THEN
  BEGIN
  IF (Language = 1)
   THEN
    BEGIN
    Unit5.FileToView:=tempdir+'EN_Help.txt';
    Unit5.CaptionToShow:='Program Help and FAQ';
    END
   ELSE
    BEGIN
    Unit5.FileToView:=tempdir+'DE_Help.txt';
    Unit5.CaptionToShow:='Programm-Hilfe und FAQ';
    END;
  Viewer_Form.ShowModal;
  END;
IF (CB_Topics.ItemIndex = 4)
 THEN
  BEGIN
  IF (Language = 1)
   THEN
    BEGIN
    Unit5.FileToView:=tempdir+'EN_Legal.txt';
    Unit5.CaptionToShow:='Legal Notes';
    END
   ELSE
    BEGIN
    Unit5.FileToView:=tempdir+'DE_Legal.txt';
    Unit5.CaptionToShow:='Rechtliche Hinweise';
    END;
  Viewer_Form.ShowModal;
  END;
IF (CB_Topics.ItemIndex = 5)
 THEN
  BEGIN
  Haupt_Form.Enabled:=FALSE;
  Unit2.Info_Form.ShowModal;
  END;
end;


procedure THaupt_Form.CB_TopicsChange(Sender: TObject);
begin
IF (CB_Topics.ItemIndex > 0)
 THEN BT_View.Enabled:=TRUE
 ELSE BT_View.Enabled:=FALSE;
end;


END.
